-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema pruebas
--

-- CREATE DATABASE IF NOT EXISTS pruebas;
-- USE pruebas;

--
-- Definition of table `trade_customer`
--

DROP TABLE IF EXISTS `trade_customer`;
CREATE TABLE `trade_customer` (
  `id_trade_customer` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(16) NOT NULL,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id_trade_customer`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `trade_customer`
--

/*!40000 ALTER TABLE `trade_customer` DISABLE KEYS */;
INSERT INTO `trade_customer` (`id_trade_customer`,`code`,`name`) VALUES 
 (1,'C00001','Customer 1'),
 (2,'C00002','Customer 2'),
 (3,'C00003','Customer 3');
/*!40000 ALTER TABLE `trade_customer` ENABLE KEYS */;




--
-- Definition of table `trade_product`
--

DROP TABLE IF EXISTS `trade_product`;
CREATE TABLE `trade_product` (
  `id_trade_product` int(11) NOT NULL AUTO_INCREMENT,
  `codeProduct` varchar(20) NOT NULL,
  `nameProduct` varchar(100) NOT NULL,
  `price` decimal(9,2) NOT NULL,
  PRIMARY KEY (`id_trade_product`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `trade_product`
--

/*!40000 ALTER TABLE `trade_product` DISABLE KEYS */;
INSERT INTO `trade_product` (`id_trade_product`,`codeProduct`,`nameProduct`,`price`) VALUES 
 (1,'000001','Product 1','10.50'),
 (2,'000002','Product 2','3.25'),
 (3,'000003','Product 3','0.25'),
 (4,'000004','Product 4','1.05');
/*!40000 ALTER TABLE `trade_product` ENABLE KEYS */;


--
-- Definition of table `trade_store`
--

DROP TABLE IF EXISTS `trade_store`;
CREATE TABLE `trade_store` (
  `id_trade_store` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(40) NOT NULL,
  `description` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id_trade_store`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `trade_store`
--

/*!40000 ALTER TABLE `trade_store` DISABLE KEYS */;
INSERT INTO `trade_store` (`id_trade_store`,`code`,`description`) VALUES 
 (1,'Store 1',''),
 (2,'Store 2',''),
 (3,'Store 3','');
/*!40000 ALTER TABLE `trade_store` ENABLE KEYS */;


--
-- Definition of table `trade_store_product`
--

DROP TABLE IF EXISTS `trade_store_product`;
CREATE TABLE `trade_store_product` (
  `id_trade_store_product` int(11) NOT NULL AUTO_INCREMENT,
  `trade_store_id` int(11) NOT NULL,
  `trade_product_id` int(11) NOT NULL,
  `stock` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_trade_store_product`),
  KEY `fk_trade_store_product_trade_store_idx` (`trade_store_id`),
  KEY `fk_trade_store_product_trade_product1_idx` (`trade_product_id`),
  CONSTRAINT `fk_trade_store_product_trade_product1` FOREIGN KEY (`trade_product_id`) REFERENCES `trade_product` (`id_trade_product`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_trade_store_product_trade_store` FOREIGN KEY (`trade_store_id`) REFERENCES `trade_store` (`id_trade_store`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `trade_store_product`
--

/*!40000 ALTER TABLE `trade_store_product` DISABLE KEYS */;
INSERT INTO `trade_store_product` (`id_trade_store_product`,`trade_store_id`,`trade_product_id`,`stock`) VALUES 
 (1,1,1,15),
 (2,1,2,15),
 (3,2,2,10),
 (4,2,3,5),
 (5,3,3,14),
 (6,3,4,26);
/*!40000 ALTER TABLE `trade_store_product` ENABLE KEYS */;

--
-- Definition of table `trade_order`
--

DROP TABLE IF EXISTS `trade_order`;
CREATE TABLE `trade_order` (
  `id_trade_order` int(11) NOT NULL AUTO_INCREMENT,
  `trade_customer_id` int(11) NOT NULL,
  `trade_store_id` int(11) NOT NULL,
  PRIMARY KEY (`id_trade_order`),
  KEY `fk_trade_order_trade_customer1_idx` (`trade_customer_id`),
  KEY `fk_trade_order_trade_store1_idx` (`trade_store_id`),
  CONSTRAINT `fk_trade_order_trade_customer1` FOREIGN KEY (`trade_customer_id`) REFERENCES `trade_customer` (`id_trade_customer`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_trade_order_trade_store1` FOREIGN KEY (`trade_store_id`) REFERENCES `trade_store` (`id_trade_store`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `trade_order`
--

/*!40000 ALTER TABLE `trade_order` DISABLE KEYS */;
INSERT INTO `trade_order` (`id_trade_order`,`trade_customer_id`,`trade_store_id`) VALUES 
 (1,1,3),
 (2,2,3);
/*!40000 ALTER TABLE `trade_order` ENABLE KEYS */;


--
-- Definition of table `trade_order_line`
--

DROP TABLE IF EXISTS `trade_order_line`;
CREATE TABLE `trade_order_line` (
  `id_trade_order_line` int(11) NOT NULL AUTO_INCREMENT,
  `trade_order_id` int(11) NOT NULL,
  `trade_product_id` int(11) NOT NULL,
  `numberArticles` int(11) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id_trade_order_line`),
  KEY `fk_trade_order_line_trade_order1_idx` (`trade_order_id`),
  KEY `fk_trade_order_line_trade_product1_idx` (`trade_product_id`),
  CONSTRAINT `fk_trade_order_line_trade_order1` FOREIGN KEY (`trade_order_id`) REFERENCES `trade_order` (`id_trade_order`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_trade_order_line_trade_product1` FOREIGN KEY (`trade_product_id`) REFERENCES `trade_product` (`id_trade_product`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `trade_order_line`
--

/*!40000 ALTER TABLE `trade_order_line` DISABLE KEYS */;
INSERT INTO `trade_order_line` (`id_trade_order_line`,`trade_order_id`,`trade_product_id`,`numberArticles`,`amount`) VALUES 
 (1,1,4,10,'10.50'),
 (2,1,3,10,'2.50'),
 (3,2,4,20,'21.00'),
 (4,2,3,2,'0.50');
/*!40000 ALTER TABLE `trade_order_line` ENABLE KEYS */;



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
